/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;

public abstract class Struct<SELF extends Struct<SELF>>
extends Pointer.Default {
    protected static final int DEFAULT_PACK_ALIGNMENT = Platform.get() == Platform.WINDOWS ? 8 : 0x40000000;
    @Nullable
    protected ByteBuffer container;

    protected Struct(long address, @Nullable ByteBuffer container) {
        super(address);
        this.container = container;
    }

    protected abstract SELF create(long var1, @Nullable ByteBuffer var3);

    public abstract int sizeof();

    public void free() {
        MemoryUtil.nmemFree(this.address());
    }

    protected static long __checkMalloc(int elements, int elementSize) {
        long bytes = ((long)elements & 0xFFFFFFFFL) * (long)elementSize;
        if (Checks.DEBUG) {
            if (elements < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (BITS32 && 0xFFFFFFFFL < bytes) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return bytes;
    }

    public static void validate(long array, int count, int SIZEOF, StructValidation validation) {
        for (int i = 0; i < count; ++i) {
            validation.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    protected static Member __member(int size) {
        return Struct.__member(size, size);
    }

    protected static Member __member(int size, int alignment) {
        return Struct.__member(size, alignment, false);
    }

    protected static Member __member(int size, int alignment, boolean forceAlignment) {
        return new Member(size, alignment, forceAlignment);
    }

    protected static Layout __struct(Member ... members) {
        return Struct.__struct(DEFAULT_PACK_ALIGNMENT, 0, members);
    }

    protected static Layout __struct(int packAlignment, int alignas, Member ... members) {
        ArrayList<Member> struct = new ArrayList<Member>(members.length);
        int size = 0;
        int alignment = alignas;
        for (Member m : members) {
            int memberAlignment = m.getAlignment(packAlignment);
            m.offset = Struct.align(size, memberAlignment);
            size = m.offset + m.size;
            alignment = Math.max(alignment, memberAlignment);
            struct.add(m);
            if (!(m instanceof Layout)) continue;
            Struct.addNestedMembers(m, struct, m.offset);
        }
        size = Struct.align(size, alignment);
        return new Layout(size, alignment, alignas != 0, struct.toArray(new Member[0]));
    }

    private static void addNestedMembers(Member nested, List<Member> members, int offset) {
        Layout layout = (Layout)nested;
        for (Member m : layout.members) {
            m.offset += offset;
            members.add(m);
        }
    }

    private static int align(int offset, int alignment) {
        return (offset - 1 | alignment - 1) + 1;
    }

    static {
        Library.initialize();
    }

    protected static class Layout
    extends Member {
        final Member[] members;

        Layout(int size, int alignment, boolean forceAlignment, Member[] members) {
            super(size, alignment, forceAlignment);
            this.members = members;
        }

        public int offsetof(int member) {
            return this.members[member].offset;
        }
    }

    protected static class Member {
        final int size;
        final int alignment;
        final boolean forcedAlignment;
        int offset;

        Member(int size, int alignment, boolean forcedAlignment) {
            this.size = size;
            this.alignment = alignment;
            this.forcedAlignment = forcedAlignment;
        }

        public int getSize() {
            return this.size;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public int getAlignment(int packAlignment) {
            return this.forcedAlignment ? this.alignment : Math.min(this.alignment, packAlignment);
        }
    }

    @FunctionalInterface
    public static interface StructValidation {
        public void validate(long var1);
    }
}

