/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL11C {
    public static native void glEnable(int var0);

    public static native void glDisable(int var0);

    public static native void glBindTexture(int var0, int var1);

    public static native void glBlendFunc(int var0, int var1);

    public static native void glClear(int var0);

    public static native void glClearColor(float var0, float var1, float var2, float var3);

    public static native void glDepthMask(boolean var0);

    public static native void glDrawArrays(int var0, int var1, int var2);

    public static native void nglDrawElements(int var0, int var1, int var2, long var3);

    public static void glDrawElements(int mode, int count, int type, long indices) {
        GL11C.nglDrawElements(mode, count, type, indices);
    }

    public static void glDrawElements(int mode, ByteBuffer indices) {
        GL11C.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        GL11C.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices));
    }

    public static native void nglGenTextures(int var0, long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenTextures() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.callocInt(1);
            GL11C.nglGenTextures(1, MemoryUtil.memAddress(textures));
            int n = textures.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteTextures(int var0, long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTextures(int texture) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.ints(texture);
            GL11C.nglDeleteTextures(1, MemoryUtil.memAddress(textures));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetFloatv(int var0, long var1);

    public static void glGetFloatv(int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check(params, 1);
        }
        GL11C.nglGetFloatv(pname, MemoryUtil.memAddress(params));
    }

    public static native void nglGetIntegerv(int var0, long var1);

    public static void glGetIntegerv(int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check(params, 1);
        }
        GL11C.nglGetIntegerv(pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetInteger(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL11C.nglGetIntegerv(pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nglGetString(int var0);

    @Nullable
    public static String glGetString(int name) {
        long __result = GL11C.nglGetString(name);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static native void glPixelStorei(int var0, int var1);

    public static native void glScissor(int var0, int var1, int var2, int var3);

    public static native void nglTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ByteBuffer pixels) {
        GL11C.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable ShortBuffer pixels) {
        GL11C.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable IntBuffer pixels) {
        GL11C.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable FloatBuffer pixels) {
        GL11C.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, @Nullable DoubleBuffer pixels) {
        GL11C.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static native void glTexParameteri(int var0, int var1, int var2);

    public static native void glTexParameterf(int var0, int var1, float var2);

    public static native void glViewport(int var0, int var1, int var2, int var3);

    static {
        GL.initialize();
    }
}

