/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.ArraySupplier;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayMap<K, V>
implements Iterable<ObjectMap.Entry<K, V>> {
    public K[] keys;
    public V[] values;
    public int size;
    public boolean ordered;

    public ArrayMap() {
        this(true, 16);
    }

    public ArrayMap(boolean ordered, int capacity) {
        this(ordered, capacity, ArraySupplier.object(), ArraySupplier.object());
    }

    public ArrayMap(boolean ordered, int capacity, ArraySupplier<K[]> keyArraySupplier, ArraySupplier<V[]> valueArraySupplier) {
        this.ordered = ordered;
        this.keys = keyArraySupplier.get(capacity);
        this.values = valueArraySupplier.get(capacity);
    }

    public int put(K key, V value) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            if (this.size == this.keys.length) {
                this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
            }
            index = this.size++;
        }
        this.keys[index] = key;
        this.values[index] = value;
        return index;
    }

    public V get(K key) {
        return this.get(key, null);
    }

    public V get(K key, V defaultValue) {
        K[] keys = this.keys;
        if (key == null) {
            for (i = this.size - 1; i >= 0; --i) {
                if (keys[i] != key) continue;
                return this.values[i];
            }
        } else {
            while (i >= 0) {
                if (key.equals(keys[i])) {
                    return this.values[i];
                }
                --i;
            }
        }
        return defaultValue;
    }

    public int indexOfKey(K key) {
        K[] keys = this.keys;
        if (key == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (keys[i] != key) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!key.equals(keys[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        K[] keys = this.keys;
        --this.size;
        if (this.ordered) {
            System.arraycopy(keys, index + 1, keys, index, this.size - index);
            System.arraycopy(this.values, index + 1, this.values, index, this.size - index);
        } else {
            keys[index] = keys[this.size];
            this.values[index] = this.values[this.size];
        }
        keys[this.size] = null;
        this.values[this.size] = null;
    }

    protected void resize(int newSize) {
        this.keys = Arrays.copyOf(this.keys, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
    }

    public int hashCode() {
        K[] keys = this.keys;
        V[] values = this.values;
        int h = 0;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            K key = keys[i];
            V value = values[i];
            if (key != null) {
                h += key.hashCode() * 31;
            }
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayMap)) {
            return false;
        }
        ArrayMap other = (ArrayMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keys = this.keys;
        V[] values = this.values;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            K key = keys[i];
            V value = values[i];
            if (!(value == null ? other.get(key, ObjectMap.dummy) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        K[] keys = this.keys;
        V[] values = this.values;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        buffer.append(keys[0]);
        buffer.append('=');
        buffer.append(values[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(keys[i]);
            buffer.append('=');
            buffer.append(values[i]);
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public Iterator<ObjectMap.Entry<K, V>> iterator() {
        return this.entries();
    }

    public Entries<K, V> entries() {
        return new Entries(this);
    }

    public static class Entries<K, V>
    implements Iterable<ObjectMap.Entry<K, V>>,
    Iterator<ObjectMap.Entry<K, V>> {
        private final ArrayMap<K, V> map;
        ObjectMap.Entry<K, V> entry = new ObjectMap.Entry();
        int index;
        boolean valid = true;

        public Entries(ArrayMap<K, V> map) {
            this.map = map;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.map.size;
        }

        @Override
        public Iterator<ObjectMap.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public ObjectMap.Entry<K, V> next() {
            if (this.index >= this.map.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            this.entry.key = this.map.keys[this.index];
            this.entry.value = this.map.values[this.index++];
            return this.entry;
        }

        @Override
        public void remove() {
            --this.index;
            this.map.removeIndex(this.index);
        }
    }
}

