/******************************************************************************
 * Spine Runtimes License Agreement
 * Last updated April 5, 2025. Replaces all prior versions.
 *
 * Copyright (c) 2013-2025, Esoteric Software LLC
 *
 * Integration of the Spine Runtimes into software or otherwise creating
 * derivative works of the Spine Runtimes is permitted under the terms and
 * conditions of Section 2 of the Spine Editor License Agreement:
 * http://esotericsoftware.com/spine-editor-license
 *
 * Otherwise, it is permitted to integrate the Spine Runtimes into software
 * or otherwise create derivative works of the Spine Runtimes (collectively,
 * "Products"), provided that each user of the Products must obtain their own
 * Spine Editor license and redistribution of the Products in any form must
 * include this license and copyright notice.
 *
 * THE SPINE RUNTIMES ARE PROVIDED BY ESOTERIC SOFTWARE LLC "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ESOTERIC SOFTWARE LLC BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES,
 * BUSINESS INTERRUPTION, OR LOSS OF USE, DATA, OR PROFITS) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THE SPINE RUNTIMES, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *****************************************************************************/

using Spine;
using Spine.Unity;
using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Playables;
using UnityEngine.Timeline;

namespace Spine.Unity.Playables {

	using Animation = Spine.Animation;

	[Serializable]
	public class SpineAnimationStateBehaviour : PlayableBehaviour {

		[NonSerialized] public TimelineClip timelineClip;

		public AnimationReferenceAsset animationReference;
		public bool loop;

		// Mix Properties
		public bool customDuration = false;
		public bool useBlendDuration = true;
		[SerializeField]
#pragma warning disable 414
		private bool isInitialized = false; // required to read preferences values from editor side.
#pragma warning restore 414
		public float mixDuration = 0.1f;
		public bool holdPrevious = false;
		public bool dontPauseWithDirector = false;
		[UnityEngine.Serialization.FormerlySerializedAs("dontPauseOnStop")]
		public bool dontEndWithClip = false;
		public float endMixOutDuration = 0.1f;

		[Range(0, 1f)]
		public float attachmentThreshold = 0.5f;

		[Range(0, 1f)]
		public float eventThreshold = 0.5f;

		[Range(0, 1f)]
		public float drawOrderThreshold = 0.5f;

		[Range(0, 1f)]
		public float alpha = 1.0f;
	}

}
